(if (findfile "acadm.lsp")
   (princ (load "gen/acadm.lsp" "\nError: acadm.lsp not loaded!"))
)

(setq s::startup '(nil
  (vlarts-init)
  (if (not (boundp 'vlax-create-object))
    (vl-load-com)
  )
  (or (load "cpl_init.lsp" nil) (load "cpl_init" nil))
  (cpl_init)
  (or (load "ath_init.lsp" nil) (load "ath_init" nil))
  (ath_init)
  (cpl_cfg_set "_RNDL" 1e-5) ; in mm
  (cpl_cfg_set "_RNDF" 1e-4) ; in mm
  (princ))
)

;starts a Netviewer Support Session
(defun c:nv ()
 (command "start" "TeamViewerQS_de-idcyradgs8.exe")
 (princ "\nTeamviewer Support: Starting session... ")
 (princ)
)

;starts a TeamViewer Support Session
(defun c:tv ()
 (command "start" "TeamViewerQS_de-idcyradgs8.exe")
 (princ "\nTeamViewer Support: Starting session... ")
 (princ)
)

;activates the option "Turn on time-sensitive right-click"
(defun c:rt ()
 (setvar "SHORTCUTMENU" 27)
 (princ "\nTime-sensitive right-click is turned on.")
 (princ)
)

;unloads the menus ATHENA, ATH-USER and INTERFACE and loads them again,
;so the ribbon tab "ATHENA", "ATH User" und "Interface" will be displayed
(defun c:atr (/ menu_list ws)
 (setvar "cmdecho" 0)
 (setq menu_list (list "ATHENA" "ATH-USER" (if (ath_logi_check) "INTERFACE" "")))
 (foreach menuname menu_list
  (if (menugroup menuname) (progn (princ (strcat "\nUnloading menu " menuname "... ")) (command "_cuiunload" menuname)))
 )
 (princ "\nLoading menus again... ")
 (if (findfile "athena.cuix") (command "_cuiload" "athena"))
 (if (findfile "ath_user.cuix") (command "_cuiload" "ath_user"))
 (if (and (findfile "interface.cuix") (ath_logi_check)) (command "_cuiload" "interface"))
 (setq ws (getvar "wscurrent")) ;store the name of the current workspace
 (command "_-wssave" ws "_yes") ;save the current workspace
 (setvar "wscurrent" ws) ;restore the current workspace
 (setvar "cmdecho" 1)
 (princ)
)

;loads the ATHENA Express Tools (additional commands without documentation)
(defun c:aie ( /
    acad_ver arx_name fas_name platform pf_ver
  )
  (setq
    platform (strcase (getvar "platform"))
    pf_ver (cond
      ((wcmatch platform "*X64*") "64")
      (T "32")
    )
    acad_ver (itoa (atoi (getvar "acadver")))
    arx_name (strcat (cpl_d_reg_read "ATH" "APPLIC")
              "ExpressTools\\"
              "ath_" (itoa (atoi (cpl_version))) "_" acad_ver "_" pf_ver "_express.arx"
             )
    fas_name (strcat (cpl_d_reg_read "ATH" "APPLIC") "ExpressTools\\ath_express.fas")
  )
    (princ (strcat "\nATHENA Express Tools: " arx_name " loaded\n"))
    (if (findfile arx_name)
        (arxload arx_name)
    )
    (princ (strcat "\nATHENA Express Tools: " fas_name " loaded\n"))
    (if (findfile fas_name)
        (load fas_name)
    )
 (princ)
)

;checks wether logiKal is installed and the "logidll.dll" exists in the main folder
(defun ath_logi_check (/ lk_lw lk_lwlist lk_folder lk_folderlist lk_logidll lk_logidlllist lk_lwfolder)
 (if (setq lk_lwlist (vl-registry-descendents "HKEY_CURRENT_USER\\Software\\Orgadata\\LogiKal"))
  (progn
   (foreach lk_lw lk_lwlist
    (foreach lk_lwfolder (vl-registry-descendents (strcat "HKEY_CURRENT_USER\\Software\\Orgadata\\LogiKal\\" lk_lw))
     (setq lk_folderlist (cons (strcat lk_lw ":/" lk_lwfolder "/") lk_folderlist))
    )
   )
   (foreach lk_folder lk_folderlist
    (if (setq lk_logidll (findfile (strcat lk_folder "logidll.dll"))) (setq lk_logidlllist (cons lk_logidll lk_logidlllist)))
   )
  )
 )
 lk_logidlllist
)

(if (findfile "acadm.lsp")
  (if acadmappend (setq s::startup (acadmappend s::startup)))
)

(princ)