(if (findfile "acadm.lsp")
   (princ (load "gen/acadm.lsp" "\nError: acadm.lsp not loaded!"))
)

(setq s::startup '(nil
  (vlarts-init)
  (if (not (boundp 'vlax-create-object))
    (vl-load-com)
  )
  (or (load "cpl_init.lsp" nil) (load "cpl_init" nil))
  (cpl_init)
  (or (load "ath_init.lsp" nil) (load "ath_init" nil))
  (ath_init)
  (cpl_cfg_set "_RNDL" 1e-5) ; in mm
  (cpl_cfg_set "_RNDF" 1e-4) ; in mm
  (princ))
)

;starts a Netviewer Support Session
(defun c:nv ()
 (command "start" "NV_Support_Participant.exe")
 (princ "\nNetviewer Support: Starting session... ")
 (princ)
)

;activates the option "Turn on time-sensitive right-click"
(defun c:rt ()
 (setvar "SHORTCUTMENU" 27)
 (princ "\nTime-sensitive right-click is turned on.")
 (princ)
)

;unloads the menus ATHENA, ATH-USER and INTERFACE and loads them again,
;so the ribbon tab "ATHENA", "ATH User" und "Interface" will be displayed
(defun c:atr (/ menu_list ws)
 (setvar "cmdecho" 0)
 (setq menu_list (list "ATHENA" "ATH-USER" (if (ath_logi_check) "INTERFACE" "")))
 (foreach menuname menu_list
  (if (menugroup menuname) (progn (princ (strcat "\nUnloading menu " menuname "... ")) (command "_cuiunload" menuname)))
 )
 (princ "\nLoading menus again... ")
 (if (or (findfile "athena.cui") (findfile "athena.cuix")) (command "_cuiload" "athena"))
 (if (or (findfile "ath_user.cui") (findfile "ath_user.cuix")) (command "_cuiload" "ath_user"))
 (if (and (or (findfile "interface.cui") (findfile "interface.cuix")) (ath_logi_check)) (command "_cuiload" "interface"))
 (setq ws (getvar "wscurrent")) ;store the name of the current workspace
 (command "_-wssave" ws "_yes") ;save the current workspace
 (setvar "wscurrent" ws) ;restore the current workspace
 (setvar "cmdecho" 1)
 (princ)
)

;checks wether logiKal is installed and the "logidll.dll" exists in the main folder
(defun ath_logi_check (/ lk_lw lk_lwlist lk_folder lk_folderlist lk_logidll lk_logidlllist lk_lwfolder)
 (if (setq lk_lwlist (vl-registry-descendents "HKEY_CURRENT_USER\\Software\\Orgadata\\LogiKal"))
  (progn
   (foreach lk_lw lk_lwlist
    (foreach lk_lwfolder (vl-registry-descendents (strcat "HKEY_CURRENT_USER\\Software\\Orgadata\\LogiKal\\" lk_lw))
     (setq lk_folderlist (cons (strcat lk_lw ":/" lk_lwfolder "/") lk_folderlist))
    )
   )
   (foreach lk_folder lk_folderlist
    (if (setq lk_logidll (findfile (strcat lk_folder "logidll.dll"))) (setq lk_logidlllist (cons lk_logidll lk_logidlllist)))
   )
  )
 )
 lk_logidlllist
)

(if (findfile "acadm.lsp")
  (if acadmappend (setq s::startup (acadmappend s::startup)))
)

(princ)
